/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.mask;

import com.mojang.datafixers.util.Pair;
import com.moulberry.axiom.collections.Position2dToIntMap;
import com.moulberry.axiom.mask.LuaJavaLoader;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.noise.SimplexNoise;
import com.moulberry.axiom.noise.VoronoiEdgesNoise;
import com.moulberry.axiom.utils.ItemStackDataHelper;
import imgui.extension.texteditor.TextEditorLanguageDefinition;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lib.Bit32Lib;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TableLib;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.jse.JseBaseLib;
import org.luaj.vm2.lib.jse.JseMathLib;
import org.luaj.vm2.lib.jse.JseStringLib;

public class LuaHelper {
    private static final LuaValue LUA_X = LuaValue.valueOf("x");
    private static final LuaValue LUA_Y = LuaValue.valueOf("y");
    private static final LuaValue LUA_Z = LuaValue.valueOf("z");
    private static LuaTable luaTableBlock = null;

    public static String getAvailableLuaFunctions(boolean allowSetBlock) {
        Object functions = "Custom variables:\nx, y, z -> coords of target location\nblocks.abc -> retrieve the id for a Block, eg. blocks.stone for the id of stone\n\nCustom functions:\ngetBlock(x, y, z) -> get the Block id at position x, y, z\ngetBlockState(x, y, z) -> get the BlockState id at position x, y, z\ngetHighestBlockYAt(x, z) -> get the y coordinate of the highest solid block at x, z\ngetSimplexNoise(x, y, z, (seed)) -> sample simplex noise at position x, y, z\ngetVoronoiEdgeNoise(x, y, z, (seed)) -> sample voronoi edge noise at position x, y, z\nisSolid(block) -> get if the block argument is solid\nisBlockTagged(block, \"tag\") -> get if the block argument has the given block tag\nwithBlockProperty(block, \"property=value\", ...) -> update property to value for block\ngetBlockProperty(block, \"property\") -> gets the value of a property as a string, or nil if it doesn't exist\n";
        if (allowSetBlock) {
            functions = (String)functions + "setBlock(x, y, z, block) -> set an additional block at the position x, y, z\n";
        }
        return functions;
    }

    public static TextEditorLanguageDefinition createTextEditorLanguageDefinition(boolean allowSetBlock) {
        TextEditorLanguageDefinition lang = TextEditorLanguageDefinition.lua();
        Map<String, String> identifiers = Map.of("getBlock", "get the Block id at position", "getBlockState", "get the BlockState id at position", "getHighestBlockYAt", "get the y coordinate of the highest solid block", "getSimplexNoise", "sample simplex noise at position", "getVoronoiEdgeNoise", "sample voronoi edge noise at position", "isSolid", "get if the block argument is solid", "isBlockTagged", "get if the block argument has the given block tag", "withBlockProperty", "update property to value for block", "getBlockProperty", "gets the value of a property as a string, or nil if it doesn't exist");
        if (allowSetBlock) {
            identifiers = new HashMap<String, String>(identifiers);
            identifiers.put("setBlock", "set an additional block at the position x, y, z");
        }
        lang.setIdentifiers(identifiers);
        return lang;
    }

    public static Globals createSandboxed() {
        Globals globals = new Globals();
        globals.load(new JseBaseLib());
        globals.load(new Bit32Lib());
        globals.load(new TableLib());
        globals.load(new JseStringLib());
        globals.load(new JseMathLib());
        globals.set("dofile", LuaValue.NIL);
        globals.set("loadfile", LuaValue.NIL);
        globals.set("collectgarbage", LuaValue.NIL);
        LuaString.s_metatable = new ReadOnlyLuaTable(LuaString.s_metatable);
        LoadState.install(globals);
        LuaC.install(globals);
        return globals;
    }

    public static LuaFunction compile(String script, Globals globals) {
        try {
            Prototype prototype = LuaC.instance.compile(new ByteArrayInputStream(script.getBytes(StandardCharsets.UTF_8)), "script");
            LuaJavaLoader loader = new LuaJavaLoader(LuaHelper.class.getClassLoader());
            return loader.load(prototype, "com.moulberry.axiom.dynamic.LuaScript" + ThreadLocalRandom.current().nextLong(Long.MAX_VALUE), "script.lua", globals);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int blockToInternalId(class_2248 block) {
        return class_7923.field_41175.method_10206((Object)block);
    }

    public static int stateToInternalId(class_2680 blockState) {
        return -class_2248.field_10651.method_10206((Object)blockState) - 1;
    }

    @Nullable
    public static class_2680 internalIdToState(int id) {
        if (id < 0) {
            int stateId = -id - 1;
            return (class_2680)class_2248.field_10651.method_10200(stateId);
        }
        Optional holderOpt = class_7923.field_41175.method_40265(id);
        if (!holderOpt.isPresent()) {
            return null;
        }
        return ((class_2248)((class_6880.class_6883)holderOpt.get()).comp_349()).method_9564();
    }

    @Nullable
    private static class_6885.class_6888<class_2248> lookupTag(String tag, Map<String, Optional<class_6885.class_6888<class_2248>>> cache) {
        Optional<class_6885.class_6888<class_2248>> cached = cache.get(tag);
        if (cached != null) {
            return cached.orElse(null);
        }
        class_2960 resourceLocation = new class_2960(tag);
        Optional<class_6885.class_6888> tagOpt = class_7923.field_41175.method_40266(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)resourceLocation));
        if (tagOpt.isEmpty()) {
            tagOpt = class_7923.field_41175.method_40272().filter(pair -> ((class_6862)pair.getFirst()).comp_327().method_12832().equals(tag)).findAny().map(Pair::getSecond);
        }
        cache.put(tag, (Optional<class_6885.class_6888<class_2248>>)tagOpt);
        return tagOpt.orElse(null);
    }

    public static void initializeGeneric(Globals globals, final @Nullable SetBlockInterface setBlockInterface) {
        final class_638 level = class_310.method_1551().field_1687;
        final class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        final Position2dToIntMap heightmap = new Position2dToIntMap(Integer.MIN_VALUE);
        globals.set(LUA_X, (LuaValue)LuaValue.valueOf(0));
        globals.set(LUA_Y, (LuaValue)LuaValue.valueOf(0));
        globals.set(LUA_Z, (LuaValue)LuaValue.valueOf(0));
        globals.set("getBlock", (LuaValue)new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue y, LuaValue z) {
                class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x.toint(), y.toint(), z.toint()));
                return LuaValue.valueOf(LuaHelper.blockToInternalId(blockState.method_26204()));
            }
        });
        globals.set("getBlockState", (LuaValue)new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue y, LuaValue z) {
                class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x.toint(), y.toint(), z.toint()));
                return LuaValue.valueOf(LuaHelper.stateToInternalId(blockState));
            }
        });
        globals.set("isSolid", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                int id = arg.toint();
                class_2680 blockState = LuaHelper.internalIdToState(id);
                if (blockState == null) {
                    return LuaValue.NIL;
                }
                return LuaValue.valueOf(blockState.method_51366());
            }
        });
        final HashMap cachedBlockTags = new HashMap();
        globals.set("isBlockTagged", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                int id = arg1.toint();
                class_2680 blockState = LuaHelper.internalIdToState(id);
                if (blockState == null) {
                    return LuaValue.NIL;
                }
                String tag = arg2.tojstring().toLowerCase(Locale.ROOT);
                class_6885.class_6888<class_2248> set = LuaHelper.lookupTag(tag, cachedBlockTags);
                if (set == null) {
                    return LuaValue.error("tag '" + tag + "' doesn't exist");
                }
                return LuaValue.valueOf(blockState.method_40143(set));
            }
        });
        globals.set("getFluidBlockStateOrAir", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                int id = arg.toint();
                class_2680 blockState = LuaHelper.internalIdToState(id);
                if (blockState == null) {
                    return LuaValue.NIL;
                }
                return LuaValue.valueOf(LuaHelper.stateToInternalId(blockState.method_26227().method_15759()));
            }
        });
        final int randomSeed = ThreadLocalRandom.current().nextInt();
        globals.set("getSimplexNoise", (LuaValue)new VarArgFunction(){

            @Override
            public Varargs onInvoke(Varargs args) {
                LuaValue seedArg = args.arg(4);
                double x = args.arg(1).todouble();
                double y = args.arg(2).todouble();
                double z = args.arg(3).todouble();
                if (!seedArg.isnil()) {
                    return LuaValue.valueOf(SimplexNoise.evaluateStatic(x, y, z, seedArg.toint()));
                }
                return LuaValue.valueOf(SimplexNoise.evaluateStatic(x, y, z, randomSeed));
            }
        });
        globals.set("getVoronoiEdgeNoise", (LuaValue)new VarArgFunction(){

            @Override
            public Varargs onInvoke(Varargs args) {
                LuaValue seedArg = args.arg(4);
                double x = args.arg(1).todouble();
                double y = args.arg(2).todouble();
                double z = args.arg(3).todouble();
                if (!seedArg.isnil()) {
                    return LuaValue.valueOf(VoronoiEdgesNoise.evaluateStatic(x, y, z, seedArg.toint(), 1.0f));
                }
                return LuaValue.valueOf(VoronoiEdgesNoise.evaluateStatic(x, y, z, randomSeed, 1.0f));
            }
        });
        globals.set("getBlockProperty", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                int block = arg1.toint();
                class_2680 blockState = LuaHelper.internalIdToState(block);
                class_2689 stateDefinition = blockState.method_26204().method_9595();
                class_2769 property = stateDefinition.method_11663(arg2.tojstring().trim().toLowerCase(Locale.ROOT));
                if (property == null) {
                    return LuaValue.NIL;
                }
                return LuaValue.valueOf(LuaHelper.serialize(blockState, property));
            }
        });
        globals.set("withBlockProperty", (LuaValue)new VarArgFunction(){

            @Override
            public Varargs onInvoke(Varargs args) {
                int block = args.toint(1);
                class_2680 blockState = LuaHelper.internalIdToState(block);
                class_2689 stateDefinition = blockState.method_26204().method_9595();
                int count = args.narg() - 1;
                for (int i = 0; i < count; ++i) {
                    String string = args.tojstring(i + 2);
                    for (String propertySetter : string.split(",")) {
                        String[] split = propertySetter.split("=");
                        if (split.length >= 2) {
                            String propertyName = split[0].trim().toLowerCase(Locale.ROOT);
                            class_2769 property = stateDefinition.method_11663(propertyName);
                            if (property == null) continue;
                            String propertyValue = split[1].trim().toLowerCase(Locale.ROOT);
                            blockState = ItemStackDataHelper.updateStateString(blockState, property, propertyValue);
                            continue;
                        }
                        return LuaValue.argerror(i + 2, "missing equals sign. for example 'facing=west'");
                    }
                }
                return LuaValue.valueOf(LuaHelper.stateToInternalId(blockState));
            }
        });
        globals.set("getHighestBlockYAt", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue z) {
                int zi;
                int xi = x.toint();
                int currentValue = heightmap.get(xi, zi = z.toint());
                if (currentValue == Integer.MIN_VALUE) {
                    class_2680 blockState;
                    int y = level.method_31600();
                    while ((blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(xi, --y, zi))).method_26204() != class_2246.field_10243 && !blockState.method_51366()) {
                    }
                    heightmap.put(xi, zi, y);
                    return LuaValue.valueOf(y);
                }
                return LuaValue.valueOf(currentValue);
            }
        });
        if (setBlockInterface != null) {
            globals.set("setBlock", (LuaValue)new VarArgFunction(){

                @Override
                public Varargs onInvoke(Varargs args) {
                    int x = args.arg(1).toint();
                    int y = args.arg(2).toint();
                    int z = args.arg(3).toint();
                    int id = args.arg(4).toint();
                    class_2680 blockState = LuaHelper.internalIdToState(id);
                    setBlockInterface.setBlock(x, y, z, blockState);
                    return LuaValue.NIL;
                }
            });
        }
        globals.set("blocks", (LuaValue)LuaHelper.getBlockTable());
    }

    private static <T extends Comparable<T>> String serialize(class_2680 blockState, class_2769<T> property) {
        Comparable comparable = blockState.method_11654(property);
        return property.method_11901(comparable);
    }

    public static void initializeMask(Globals globals, final MaskContext maskContext, int x, int y, int z) {
        globals.set(LUA_X, (LuaValue)LuaValue.valueOf(x));
        globals.set(LUA_Y, (LuaValue)LuaValue.valueOf(y));
        globals.set(LUA_Z, (LuaValue)LuaValue.valueOf(z));
        globals.set("getBlock", (LuaValue)new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue y, LuaValue z) {
                class_2680 blockState = maskContext.getBlockStateAt(x.toint(), y.toint(), z.toint());
                return LuaValue.valueOf(LuaHelper.blockToInternalId(blockState.method_26204()));
            }
        });
        globals.set("getBlockState", (LuaValue)new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue y, LuaValue z) {
                class_2680 blockState = maskContext.getBlockStateAt(x.toint(), y.toint(), z.toint());
                return LuaValue.valueOf(LuaHelper.stateToInternalId(blockState));
            }
        });
        globals.set("isSolid", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                int id = arg.toint();
                class_2680 blockState = LuaHelper.internalIdToState(id);
                if (blockState == null) {
                    return LuaValue.NIL;
                }
                return LuaValue.valueOf(blockState.method_51366());
            }
        });
        final HashMap cachedBlockTags = new HashMap();
        globals.set("isBlockTagged", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                int id = arg1.toint();
                class_2680 blockState = LuaHelper.internalIdToState(id);
                if (blockState == null) {
                    return LuaValue.NIL;
                }
                String tag = arg2.tojstring().toLowerCase(Locale.ROOT);
                class_6885.class_6888<class_2248> set = LuaHelper.lookupTag(tag, cachedBlockTags);
                if (set == null) {
                    return LuaValue.error("tag '" + tag + "' doesn't exist");
                }
                return LuaValue.valueOf(blockState.method_40143(set));
            }
        });
        globals.set("getFluidBlockStateOrAir", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                int id = arg.toint();
                class_2680 blockState = LuaHelper.internalIdToState(id);
                if (blockState == null) {
                    return LuaValue.NIL;
                }
                return LuaValue.valueOf(LuaHelper.stateToInternalId(blockState.method_26227().method_15759()));
            }
        });
        final int randomSeed = ThreadLocalRandom.current().nextInt();
        globals.set("getSimplexNoise", (LuaValue)new VarArgFunction(){

            @Override
            public Varargs onInvoke(Varargs args) {
                LuaValue seedArg = args.arg(4);
                double x = args.arg(1).todouble();
                double y = args.arg(2).todouble();
                double z = args.arg(3).todouble();
                if (!seedArg.isnil()) {
                    return LuaValue.valueOf(SimplexNoise.evaluateStatic(x, y, z, seedArg.toint()));
                }
                return LuaValue.valueOf(SimplexNoise.evaluateStatic(x, y, z, randomSeed));
            }
        });
        globals.set("getVoronoiEdgeNoise", (LuaValue)new VarArgFunction(){

            @Override
            public Varargs onInvoke(Varargs args) {
                LuaValue seedArg = args.arg(4);
                double x = args.arg(1).todouble();
                double y = args.arg(2).todouble();
                double z = args.arg(3).todouble();
                if (!seedArg.isnil()) {
                    return LuaValue.valueOf(VoronoiEdgesNoise.evaluateStatic(x, y, z, seedArg.toint(), 1.0f));
                }
                return LuaValue.valueOf(VoronoiEdgesNoise.evaluateStatic(x, y, z, randomSeed, 1.0f));
            }
        });
        globals.set("getBlockProperty", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                int block = arg1.toint();
                class_2680 blockState = LuaHelper.internalIdToState(block);
                class_2689 stateDefinition = blockState.method_26204().method_9595();
                class_2769 property = stateDefinition.method_11663(arg2.tojstring().trim().toLowerCase(Locale.ROOT));
                if (property == null) {
                    return LuaValue.NIL;
                }
                return LuaValue.valueOf(LuaHelper.serialize(blockState, property));
            }
        });
        globals.set("withBlockProperty", (LuaValue)new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue block, LuaValue propertyName, LuaValue propertyValue) {
                class_2680 blockState = LuaHelper.internalIdToState(block.toint());
                class_2689 stateDefinition = blockState.method_26204().method_9595();
                class_2769 property = stateDefinition.method_11663(propertyName.tojstring());
                if (property != null) {
                    blockState = ItemStackDataHelper.updateStateString(blockState, property, propertyValue.tojstring());
                }
                return LuaValue.valueOf(LuaHelper.stateToInternalId(blockState));
            }
        });
        globals.set("getHighestBlockYAt", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue z) {
                return LuaValue.valueOf(maskContext.getHighestBlock(x.toint(), z.toint()));
            }
        });
        globals.set("blocks", (LuaValue)LuaHelper.getBlockTable());
    }

    public static void setPosition(Globals globals, int x, int y, int z) {
        globals.set(LUA_X, (LuaValue)LuaValue.valueOf(x));
        globals.set(LUA_Y, (LuaValue)LuaValue.valueOf(y));
        globals.set(LUA_Z, (LuaValue)LuaValue.valueOf(z));
    }

    private static LuaTable getBlockTable() {
        if (luaTableBlock != null) {
            return luaTableBlock;
        }
        luaTableBlock = new LuaTable();
        HashMap<String, LuaTable> subTables = new HashMap<String, LuaTable>();
        for (class_2248 block : class_7923.field_41175) {
            class_2960 key = class_7923.field_41175.method_10221((Object)block);
            int value = class_7923.field_41175.method_10206((Object)block);
            String namespace = key.method_12836();
            if (namespace.equals("minecraft")) {
                luaTableBlock.set(key.method_12832(), value);
                continue;
            }
            if (!subTables.containsKey(namespace)) {
                LuaTable subTable = new LuaTable();
                luaTableBlock.set(namespace, (LuaValue)subTable);
                subTables.put(namespace, subTable);
            }
            ((LuaTable)subTables.get(namespace)).set(key.method_12832(), value);
        }
        return luaTableBlock;
    }

    static class ReadOnlyLuaTable
    extends LuaTable {
        public ReadOnlyLuaTable(LuaValue table) {
            this.presize(table.length(), 0);
            Varargs n = table.next(LuaValue.NIL);
            while (!n.arg1().isnil()) {
                LuaValue key = n.arg1();
                LuaValue value = n.arg(2);
                super.rawset(key, value.istable() ? new ReadOnlyLuaTable(value) : value);
                n = table.next(n.arg1());
            }
        }

        @Override
        public LuaValue setmetatable(LuaValue metatable) {
            return ReadOnlyLuaTable.error("table is read-only");
        }

        @Override
        public void set(int key, LuaValue value) {
            ReadOnlyLuaTable.error("table is read-only");
        }

        @Override
        public void rawset(int key, LuaValue value) {
            ReadOnlyLuaTable.error("table is read-only");
        }

        @Override
        public void rawset(LuaValue key, LuaValue value) {
            ReadOnlyLuaTable.error("table is read-only");
        }

        @Override
        public LuaValue remove(int pos) {
            return ReadOnlyLuaTable.error("table is read-only");
        }
    }

    @FunctionalInterface
    public static interface SetBlockInterface {
        public void setBlock(int var1, int var2, int var3, class_2680 var4);
    }
}

